<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cadastros', function (Blueprint $table) {
            $table->id();
            $table->string('nome', 250); // Nome do cadastro
            $table->string('n_identificacao', 60)->unique();
            $table->string('tipo_documento', 11); // Número de identificação
            $table->string('email', 60)->unique(); // Email
            $table->string('telefone', 60); // Telefone
            $table->string('n_mecanografico', 15)->unique(); // Número mecanográfico
            $table->foreignId('orgao_id')->constrained('orgao'); // Relacionamento com orgaos
            $table->string('arquivo_identificacao');
            $table->string('arquivo_declaracao');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cadastros');
    }
};
